#include <bits/stdc++.h>
using namespace std;

const int N = 200005;

int st[4 * N];
int lazy[4 * N];
int a[N];

int build(int id, int l, int r){
    if(l == r)
        return st[id] = a[l];

    int mid = (l + r) / 2;
    int s1 = build(id * 2 + 1, l, mid);
    int s2 = build(id * 2 + 2, mid + 1, r);

    return st[id] = s1 + s2;
}

void updNode(int v, int id, int l, int r){
    lazy[id] += v;
    lazy[id] %= 2;
    if(lazy[id] == 1)
        st[id] = (r - l + 1) - st[id];
}

void shift(int id, int l, int r){
    int mid = (l + r) / 2;
    updNode(lazy[id] % 2, id * 2 + 1, l, mid);
    updNode(lazy[id] % 2, id * 2 + 2, mid + 1, r);
    lazy[id] = 0;
}

void update(int x, int y, int id, int l, int r){
    if(x > r || y < l)
        return;

    if(x <= l && r <= y){
        updNode(1, id, l, r);
        return;
    }

    shift(id, l, r);

    int mid = (l + r) / 2;
    update(x, y, id * 2 + 1, l, mid);
    update(x, y, id * 2 + 2, mid + 1, r);

    st[id] = st[id * 2 + 1] + st[id * 2 + 2];
}

int sum(int x, int y, int id, int l, int r){
    if(x > r || y < l)
        return 0;

    if(x <= l && r <= y){
        return st[id];
    }

    shift(id, l, r);

    int mid = (l + r) / 2;
    int s1 = sum(x, y, id * 2 + 1, l, mid);
    int s2 = sum(x, y, id * 2 + 2, mid + 1, r);

    return s1 + s2;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int n, c, q;
    cin >> n >> c >> q;
    string str;
    cin >> str;
    for(int i = 0; i < n; ++i){
        a[i] = str[i] - '0';
    }

    build(0, 0, n - 1);

    while(q--){
        int x, y;
        cin >> x >> y;
        x--;y--;

        update(x, y, 0, 0, n - 1);
        int res = sum(0, n - 1, 0, 0, n - 1);
        cout << res << "\n";
    }

    return 0;
}

/*
7 7 3
0111011
1 2
1 2
2 6
---
5
5
2

****

16 16 5
0111001111011001
16 16
1 1
3 3
5 5
7 7
---
9
10
9
10
9


*/